# Examples of supported barcodes

These are examples of supported barcodes with this library.

All types can be found in the src/Types directory.



### TypeCode39

![Barcode 1234567890ABC as Picqer\Barcode\Types\TypeCode39](tests/verified-files/TypeCode39-1234567890ABC.svg)

### TypeCode39Checksum

![Barcode 1234567890ABC as Picqer\Barcode\Types\TypeCode39Checksum](tests/verified-files/TypeCode39Checksum-1234567890ABC.svg)

### TypeCode39Extended

![Barcode 1234567890abcABC as Picqer\Barcode\Types\TypeCode39Extended](tests/verified-files/TypeCode39Extended-1234567890abcABC.svg)

### TypeCode39ExtendedChecksum

![Barcode 1234567890abcABC as Picqer\Barcode\Types\TypeCode39ExtendedChecksum](tests/verified-files/TypeCode39ExtendedChecksum-1234567890abcABC.svg)

### TypeCode93

![Barcode 1234567890abcABC as Picqer\Barcode\Types\TypeCode93](tests/verified-files/TypeCode93-1234567890abcABC.svg)

### TypeStandard2of5

![Barcode 1234567890 as Picqer\Barcode\Types\TypeStandard2of5](tests/verified-files/TypeStandard2of5-1234567890.svg)

### TypeStandard2of5Checksum

![Barcode 1234567890 as Picqer\Barcode\Types\TypeStandard2of5Checksum](tests/verified-files/TypeStandard2of5Checksum-1234567890.svg)

### TypeInterleaved25

![Barcode 1234567890 as Picqer\Barcode\Types\TypeInterleaved25](tests/verified-files/TypeInterleaved25-1234567890.svg)

### TypeInterleaved25Checksum

![Barcode 1234567890 as Picqer\Barcode\Types\TypeInterleaved25Checksum](tests/verified-files/TypeInterleaved25Checksum-1234567890.svg)

### TypeEan13

![Barcode 081231723897 as Picqer\Barcode\Types\TypeEan13](tests/verified-files/TypeEan13-081231723897.svg)

![Barcode 0049000004632 as Picqer\Barcode\Types\TypeEan13](tests/verified-files/TypeEan13-0049000004632.svg)

![Barcode 004900000463 as Picqer\Barcode\Types\TypeEan13](tests/verified-files/TypeEan13-004900000463.svg)

### TypeITF14

![Barcode 00012345600012 as Picqer\Barcode\Types\TypeITF14](tests/verified-files/TypeITF14-00012345600012.svg)

![Barcode 05400141288766 as Picqer\Barcode\Types\TypeITF14](tests/verified-files/TypeITF14-05400141288766.svg)

### TypeCode128

![Barcode 081231723897 as Picqer\Barcode\Types\TypeCode128](tests/verified-files/TypeCode128-081231723897.svg)

![Barcode 1234567890abcABC-283*33 as Picqer\Barcode\Types\TypeCode128](tests/verified-files/TypeCode128-1234567890abcABC-283-33.svg)

### TypeCode128A

![Barcode 1234567890 as Picqer\Barcode\Types\TypeCode128A](tests/verified-files/TypeCode128A-1234567890.svg)

### TypeCode128B

![Barcode 081231723897 as Picqer\Barcode\Types\TypeCode128B](tests/verified-files/TypeCode128B-081231723897.svg)

![Barcode 1234567890abcABC-283*33 as Picqer\Barcode\Types\TypeCode128B](tests/verified-files/TypeCode128B-1234567890abcABC-283-33.svg)

### TypeUpcExtension2

![Barcode 22 as Picqer\Barcode\Types\TypeUpcExtension2](tests/verified-files/TypeUpcExtension2-22.svg)

### TypeUpcExtension5

![Barcode 1234567890abcABC-283*33 as Picqer\Barcode\Types\TypeUpcExtension5](tests/verified-files/TypeUpcExtension5-1234567890abcABC-283-33.svg)

### TypeEan8

![Barcode 1234568 as Picqer\Barcode\Types\TypeEan8](tests/verified-files/TypeEan8-1234568.svg)

### TypeUpcA

![Barcode 123456789 as Picqer\Barcode\Types\TypeUpcA](tests/verified-files/TypeUpcA-123456789.svg)

### TypeUpcE

![Barcode 123456789 as Picqer\Barcode\Types\TypeUpcE](tests/verified-files/TypeUpcE-123456789.svg)

### TypeMsi

![Barcode 123456789 as Picqer\Barcode\Types\TypeMsi](tests/verified-files/TypeMsi-123456789.svg)

### TypeMsiChecksum

![Barcode 123456789 as Picqer\Barcode\Types\TypeMsiChecksum](tests/verified-files/TypeMsiChecksum-123456789.svg)

### TypePostnet

![Barcode 123456789 as Picqer\Barcode\Types\TypePostnet](tests/verified-files/TypePostnet-123456789.svg)

### TypePlanet

![Barcode 123456789 as Picqer\Barcode\Types\TypePlanet](tests/verified-files/TypePlanet-123456789.svg)

### TypeRms4cc

![Barcode 123456789 as Picqer\Barcode\Types\TypeRms4cc](tests/verified-files/TypeRms4cc-123456789.svg)

### TypeKix

![Barcode 123456789 as Picqer\Barcode\Types\TypeKix](tests/verified-files/TypeKix-123456789.svg)

### TypeIntelligentMailBarcode

![Barcode 123456789 as Picqer\Barcode\Types\TypeIntelligentMailBarcode](tests/verified-files/TypeIntelligentMailBarcode-123456789.svg)

### TypeCodabar

![Barcode 123456789 as Picqer\Barcode\Types\TypeCodabar](tests/verified-files/TypeCodabar-123456789.svg)

### TypeCode11

![Barcode 123456789 as Picqer\Barcode\Types\TypeCode11](tests/verified-files/TypeCode11-123456789.svg)

### TypePharmacode

![Barcode 123456789 as Picqer\Barcode\Types\TypePharmacode](tests/verified-files/TypePharmacode-123456789.svg)

### TypePharmacodeTwoCode

![Barcode 123456789 as Picqer\Barcode\Types\TypePharmacodeTwoCode](tests/verified-files/TypePharmacodeTwoCode-123456789.svg)

### TypeTelepen

![Barcode 1234567890ASCD as Picqer\Barcode\Types\TypeTelepen](tests/verified-files/TypeTelepen-1234567890ASCD.svg)

### TypeTelepenNumeric

![Barcode 1234567890 as Picqer\Barcode\Types\TypeTelepenNumeric](tests/verified-files/TypeTelepenNumeric-1234567890.svg)



*This file is generated by generate-examples.php*